attribute vec4 a_position;
attribute vec2 a_texCoord;
uniform vec2 u_uvSize;
uniform vec2 u_gridHalf;


varying vec2 v_gridTexCoord;
varying vec2 v_texCoord;

void main()
{
    gl_Position = a_position;
    //->to grid coordinates using inverse transform
    v_gridTexCoord = (CC_MVPMatrix * vec4(a_position.x,a_position.y,0.0,1.0)).xy;
    v_gridTexCoord += u_gridHalf;
    v_gridTexCoord/= (2.0*u_gridHalf) ; //0->1 coordinate in grid/occluder map space
    v_texCoord = a_texCoord * u_uvSize;
}
